package jamezo97.clonecraft.entity;

import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.GenePool;
import jamezo97.clonecraft.dna.IModifiable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class EntityModifiable extends EntityCreature implements IEntityAdditionalSpawnData, IModifiable{
	
	@Override
	public float getBaseYOffset() {
		return baseYOffset;
	}
	
	@Override
	public void setGeneScaling(float scale) {
		this.geneScaling = scale;
	}

	@Override
	public float getGeneScaling() {
		return geneScaling;
	}

	@Override
	public float getBaseXSize() {
		return baseSizeX;
	}

	@Override
	public float getBaseYSize() {
		return baseSizeY;
	}

	@Override
	public int getGeneStrength(Gene gene) {
		return genePool.getGeneStrength(gene);
	}

	@Override
	public void setGene(Gene gene, int level) {
		genePool.setGene(gene, level);
	}

	@Override
	public boolean removeGene(Gene gene) {
		return genePool.removeGene(gene);
	}

	@Override
	public boolean hasGene(Gene gene) {
		return genePool.hasGene(gene);
	}

	@Override
	public GenePool getGenePool() {
		return genePool;
	}

	@Override
	public void writeSpawnData(ByteArrayDataOutput data) {
		genePool.writeSpawnData(data);
	}

	@Override
	public void readSpawnData(ByteArrayDataInput data) {
		genePool.readSpawnData(data);
	}
	
	

	public float baseSizeX = 0.5f, baseSizeY = 1.62f, geneScaling = 1, baseYOffset = 1.62f;

	private float moveSpeed = 1f;
	
	float speedInAir = 0.2f;
	
	public EntityModifiable(World par1World) {
		super(par1World);
		genePool = new GenePool(this);
	}
	
	public void setScale(float width, float height){
		setSize(width, height);
	}
	
	
	@SideOnly(Side.CLIENT)

    /**
     * Gets the Icon Index of the item currently held
     */
    public Icon getItemIcon(ItemStack par1ItemStack, int par2)
    {
        return par1ItemStack.getItem().getIcon(par1ItemStack, par2);
    }

	
	public void setMoveSpeed(float speed){
		moveSpeed = speed;
	}
	
	public float getMoveSpeed(){
		return moveSpeed;
	}
	
	public void setSpeedInAir(float speed){
		this.speedInAir = speed;
		this.jumpMovementFactor = speed;
	}
	
	public float getSpeedInAir(){
		return speedInAir;
	}
	

	@Override
	public void onLivingUpdate() {
		super.onLivingUpdate();
		this.jumpMovementFactor = this.speedInAir;

	    if (this.isSprinting())
	    {
	        this.jumpMovementFactor = (float)((double)this.jumpMovementFactor + (double)this.speedInAir * 0.3D);
	    }
	}

	
	public PathEntity moveTo(double x, double y, double z) {
		PathEntity path;
		getNavigator().setPath(path = getNavigator().getPathToXYZ(x, y, z), moveSpeed);
		return path;
	}
	
	public PathEntity moveToEntity(Entity e) {
		PathEntity path;
		getNavigator().setPath(path = getNavigator().getPathToEntityLiving(e), moveSpeed);
		return path;
	}
	
	public void setPathToEntity(PathEntity path) {
		getNavigator().setPath(path, moveSpeed);
	}

	GenePool genePool = null;
	
	@Override
	public void onUpdate() {
		super.onUpdate();
		genePool.onUpdate();
	}
	
	@Override
	public float getBaseStepHeight() {
		return 0.5f;
	}

	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		genePool.writeToNBT(nbt);
	}


	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		genePool.readFromNBT(nbt);
		
	}

	public boolean shouldApplySizeChange() {
		return true;
	}

}
